/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model.output;

import com.badlogic.gdx.math.GridPoint2;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import technology.rocketjump.undermount.mapgen.generators.SequentialIdGenerator;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.output.CompassDirection;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapEdgeSection;

public class MapRegion {
    private final long regionId;
    private Set<GameMapTile> tiles = new HashSet<GameMapTile>();
    public final TileType tileType;
    private int numBorderTiles = 0;
    public final List<MapEdgeSection> edges = new LinkedList<MapEdgeSection>();
    public final Set<CompassDirection> edgeDirections = EnumSet.noneOf(CompassDirection.class);
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;

    public MapRegion(TileType tileType) {
        this.regionId = SequentialIdGenerator.nextId();
        this.tileType = tileType;
    }

    public void add(GameMapTile tile, AbstractGameMap parentMap) {
        if (!this.contains(tile)) {
            tile.setRegion(this);
            if (tile.getPosition().x < this.minX) {
                this.minX = tile.getPosition().x;
            }
            if (tile.getPosition().x > this.maxX) {
                this.maxX = tile.getPosition().x;
            }
            if (tile.getPosition().y < this.minY) {
                this.minY = tile.getPosition().y;
            }
            if (tile.getPosition().y > this.maxY) {
                this.maxY = tile.getPosition().y;
            }
            if (tile.isBorderTile()) {
                ++this.numBorderTiles;
                if (parentMap != null) {
                    if (tile.getPosition().x == 0) {
                        this.edgeDirections.add(CompassDirection.WEST);
                        this.updateEdges(CompassDirection.WEST, tile.getPosition());
                    } else if (tile.getPosition().x == parentMap.getWidth() - 1) {
                        this.edgeDirections.add(CompassDirection.EAST);
                        this.updateEdges(CompassDirection.EAST, tile.getPosition());
                    }
                    if (tile.getPosition().y == 0) {
                        this.edgeDirections.add(CompassDirection.SOUTH);
                        this.updateEdges(CompassDirection.SOUTH, tile.getPosition());
                    } else if (tile.getPosition().y == parentMap.getHeight() - 1) {
                        this.edgeDirections.add(CompassDirection.NORTH);
                        this.updateEdges(CompassDirection.NORTH, tile.getPosition());
                    }
                }
            }
        }
        this.tiles.add(tile);
    }

    private void updateEdges(CompassDirection direction, GridPoint2 position) {
        LinkedList<MapEdgeSection> adjacentEdgesInDirection = new LinkedList<MapEdgeSection>();
        for (MapEdgeSection edge : this.edges) {
            if (edge.direction != direction || !edge.isAdjacent(position)) continue;
            adjacentEdgesInDirection.add(edge);
        }
        if (adjacentEdgesInDirection.size() == 0) {
            MapEdgeSection edgeSection = new MapEdgeSection(direction, position);
            this.edges.add(edgeSection);
        } else {
            for (MapEdgeSection adjacentEdge : adjacentEdgesInDirection) {
                adjacentEdge.addAdjacentPoint(position);
            }
        }
    }

    public boolean contains(GameMapTile tile) {
        return this.tiles.contains(tile);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public TileType getTileType() {
        return this.tileType;
    }

    public int size() {
        return this.tiles.size();
    }

    public int getNumBorderTiles() {
        return this.numBorderTiles;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public void remove(GameMapTile tile) {
        if (this.contains(tile)) {
            this.tiles.remove(tile);
            tile.setRegion(null);
        }
    }

    public Set<GameMapTile> getTiles() {
        return this.tiles;
    }

    public List<MapEdgeSection> getEdges() {
        return this.edges;
    }

    public Set<CompassDirection> getEdgeDirections() {
        return this.edgeDirections;
    }
}

